<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Texto para Imagem</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f9;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
            padding: 10px; /* Adicionado para permitir algum espaço em telas menores */
        }
        .form-container {
            background-color: #ffffff;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            max-width: 500px;
            width: 100%;
            position: relative;
            text-align: center; /* Centraliza o conteúdo dentro da caixa */
        }
        .form-container::before {
            content: "";
            background-image: url('rtx/imgtexto.png');
            background-size: cover;
            background-position: center center; /* Centraliza verticalmente e horizontalmente */
            background-position-x: center; /* Centraliza horizontalmente */
            width: 100%;
            height: 170px; /* Ajuste a altura conforme necessário */
            display: block;
            border-top-left-radius: 10px;
            border-top-right-radius: 10px;
            margin: 0 auto 20px auto; /* Centraliza vertical e horizontalmente */
        }
        .form-container h2 {
            margin-top: 0;
            font-size: 24px;
            text-align: center;
        }
        .form-container label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
            color: red; /* Adicionado para deixar o texto vermelho */
        }
        .form-container input[type="text"],
        .form-container textarea {
            width: calc(100% - 22px);
            padding: 10px;
            margin-bottom: 15px;
            border: 1px solid #ddd;
            border-radius: 5px;
            box-sizing: border-box; /* Adicionado para garantir que a largura inclua padding e borda */
        }
        .form-container textarea {
            resize: vertical; /* Permite redimensionar verticalmente */
            min-height: 150px; /* Aumenta a altura mínima da caixa de texto */
        }
        .form-container input[type="submit"] {
            width: 100%;
            padding: 10px;
            background-color: #007BFF;
            border: none;
            border-radius: 5px;
            color: #fff;
            font-size: 16px;
            cursor: pointer;
        }
        .form-container input[type="submit"]:hover {
            background-color: #0056b3;
        }
        /* Novo estilo para o aviso de limite de caracteres */
        #char-limit-warning {
            font-size: 14px;
            color: red;
            margin-top: -5px; /* Ajuste de margem para alinhar com a caixa de texto */
        }
    </style>
</head>
<body>
    <div class="form-container">
        <h2>Envie a Mensagem</h2>
        <!-- Adicionado um parágrafo para exibir o aviso sobre o limite de caracteres -->
        <p id="char-limit-warning"></p>
        <form action="generate_image.php" method="post">
            <label for="text" style="color: red;">Digite a mensagem (limite de 71 caracteres):</label>
            <textarea id="text" name="text" rows="4" required maxlength="71"></textarea>
            <input type="submit" value="Enviar Mensagem">
        </form>
    </div>

    <!-- Script modificado para exibir o alerta de sucesso -->
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            var textArea = document.getElementById('text');
            var charLimitWarning = document.getElementById('char-limit-warning');

            textArea.addEventListener('input', function () {
                var charCount = textArea.value.length;
                if (charCount > 71) {
                    charLimitWarning.textContent = 'Limite de caracteres excedido!';
                } else {
                    charLimitWarning.textContent = '';
                }
            });
            
            // Verifica se a URL contém o parâmetro 'success'
            if (window.location.search.includes('success')) {
                alert('Imagem salva com sucesso!');
            }
        });
    </script>
</body>
</html>
